/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.config.InvokableAction;
import jace.config.Reconfigurable;
import jace.core.CPU;
import jace.core.Card;
import jace.core.Keyboard;
import jace.core.RAM;
import jace.core.Video;
import java.io.IOException;

public abstract class Computer
implements Reconfigurable {
    private static Computer theComputer;
    public RAM memory;
    public CPU cpu;
    public Video video;
    public Keyboard keyboard;

    public Computer() {
        theComputer = this;
        this.keyboard = new Keyboard();
    }

    public RAM getMemory() {
        return this.memory;
    }

    public void notifyVBLStateChanged(boolean state) {
        for (Card c : this.getMemory().cards) {
            if (c == null) continue;
            c.notifyVBLStateChanged(state);
        }
    }

    public void setMemory(RAM memory) {
        if (this.memory != memory) {
            if (this.memory != null) {
                this.memory.detach();
            }
            memory.attach();
        }
        this.memory = memory;
    }

    public void waitForNextCycle() {
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public void setCpu(CPU cpu) {
        this.cpu = cpu;
    }

    public void loadRom(String path) throws IOException {
        this.memory.loadRom(path);
    }

    @InvokableAction(name="Cold boot", description="Process startup sequence from power-up", category="general", alternatives="Full reset;reset emulator")
    public abstract void coldStart();

    @InvokableAction(name="Warm boot", description="Process user-initatiated reboot (ctrl+apple+reset)", category="general", alternatives="reboot;reset;three-finger-salute")
    public abstract void warmStart();

    public static Computer getComputer() {
        return theComputer;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    protected abstract boolean isRunning();

    protected abstract void doPause();

    protected abstract void doResume();

    @InvokableAction(name="Pause", description="Stops the computer, allowing reconfiguration of core elements", alternatives="freeze;halt")
    public static boolean pause() {
        boolean result = false;
        if (theComputer != null) {
            result = theComputer.isRunning();
            theComputer.doPause();
        }
        return result;
    }

    @InvokableAction(name="Resume", description="Resumes the computer if it was previously paused", alternatives="unpause;unfreeze;resume")
    public static void resume() {
        if (theComputer != null) {
            theComputer.doResume();
        }
    }
}

